% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_regression.R
\name{logistic_regression}
\alias{logistic_regression}
\title{Logistic regression}
\usage{
logistic_regression(
  data = NULL,
  formula = NULL,
  formula_1 = NULL,
  formula_2 = NULL,
  z_values_keep = FALSE,
  constant_row_clean = TRUE,
  odds_ratio_cols_combine = TRUE,
  round_b_and_se = 3,
  round_z = 3,
  round_p = 3,
  round_odds_ratio = 3,
  round_r_sq = 3,
  round_model_chi_sq = 3,
  pretty_round_p_value = TRUE,
  print_glm_default_summary = FALSE,
  print_summary_dt_list = TRUE,
  print_model_comparison = TRUE,
  output_type = "summary_dt_list"
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{formula}{formula for estimating a single logistic regression model}

\item{formula_1}{formula for estimating logistic regression model 1 of 2}

\item{formula_2}{formula for estimating logistic regression model 2 of 2}

\item{z_values_keep}{logical. Should the z values be kept in the table?
(default = FALSE)}

\item{constant_row_clean}{logical. Should the row for the constant
be cleared except for b and standard error of b? (default = TRUE)}

\item{odds_ratio_cols_combine}{logical. Should the odds ratio columns
be combined? (default = TRUE)}

\item{round_b_and_se}{number of decimal places to which to round
b and standard error of b (default = 3)}

\item{round_z}{number of decimal places to which to round
z values (default = 3)}

\item{round_p}{number of decimal places to which to round
p-values (default = 3)}

\item{round_odds_ratio}{number of decimal places to which to round
odds ratios (default = 3)}

\item{round_r_sq}{number of decimal places to which to round
R-squared values (default = 3)}

\item{round_model_chi_sq}{number of decimal places to which to round
model chi-squared values (default = 3)}

\item{pretty_round_p_value}{logical. Should the p-values be rounded
in a pretty format (i.e., lower threshold: "<.001").
By default, \code{pretty_round_p_value = TRUE}.}

\item{print_glm_default_summary}{logical. Should the default summary
output of the glm objects be printed? (default = FALSE)}

\item{print_summary_dt_list}{logical. Should the summaries of
logistic regressions in a data table format be printed? (default = TRUE)}

\item{print_model_comparison}{logical. Should the comparison of
two logistic regression models be printed? (default = TRUE)}

\item{output_type}{If \code{output_type = "summary_dt_list"} (default),
the output of the function will be summaries of the two logistic
regressions in a data.table format.
If \code{output_type = "glm_object_list"}, the output of the
function will be the two \code{glm} objects estimating logistic
regression models. If \code{output_type = "glm_default_summary_list"},
the output of the function will be the R's default \code{summary}
output for the two \code{glm} objects estimating logistic
regression models. If \code{output_type = "model_comparison_stats"},
the output of the function will be statistics from comparison of the
two logistic regression models. If \code{output_type = "all"},
the output of the function will be a list of the aforementioned outputs.}
}
\value{
the output will be a summary of logistic regression results,
unless set otherwise by the \code{output_type} argument to the function.
}
\description{
Conduct a logistic regression analysis
}
\examples{
logistic_regression(data = mtcars, formula = am ~ mpg)
logistic_regression(
data = mtcars,
formula_1 = am ~ mpg,
formula_2 = am ~ mpg + wt)
}
