% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-aliases.R
\name{new_model_class}
\alias{new_model_class}
\title{Model}
\usage{
new_model_class(
  classname,
  initialize = NULL,
  call = NULL,
  train_step = NULL,
  predict_step = NULL,
  test_step = NULL,
  compute_loss = NULL,
  compute_metrics = NULL,
  ...,
  public = list(),
  private = list(),
  inherit = NULL,
  parent_env = parent.frame()
)
}
\arguments{
\item{classname}{String, the name of the custom class. (Conventionally, CamelCase).}

\item{initialize, call, train_step, predict_step, test_step, compute_loss, compute_metrics}{Optional methods that can be overridden.}

\item{..., public}{Additional methods or public members of the custom class.}

\item{private}{Named list of R objects (typically, functions) to include in
instance private environments. \code{private} methods will have all the same
symbols in scope as public methods (See section "Symbols in Scope"). Each
instance will have it's own \code{private} environment. Any objects
in \code{private} will be invisible from the Keras framework and the Python
runtime.}

\item{inherit}{What the custom class will subclass. By default, the base keras class.}

\item{parent_env}{The R environment that all class methods will have as a grandparent.}
}
\value{
A model constructor function, which you can call to create an
instance of the new model type.
}
\description{
\code{new_model_class()} is an alias for \code{\link[=Model]{Model()}}.
See \verb{?}\code{\link[=Model]{Model()}} for the full documentation.
}
\keyword{internal}
