% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_log_cosh}
\alias{metric_log_cosh}
\title{Logarithm of the hyperbolic cosine of the prediction error.}
\usage{
metric_log_cosh(y_true, y_pred)
}
\arguments{
\item{y_true}{Ground truth values with shape = \verb{[batch_size, d0, .. dN]}.}

\item{y_pred}{The predicted values with shape = \verb{[batch_size, d0, .. dN]}.}
}
\value{
Logcosh error values with shape = \verb{[batch_size, d0, .. dN-1]}.
}
\description{
Formula:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{loss <- mean(log(cosh(y_pred - y_true)), axis=-1)
}\if{html}{\out{</div>}}

Note that \code{log(cosh(x))} is approximately equal to \code{(x ** 2) / 2} for small
\code{x} and to \code{abs(x) - log(2)} for large \code{x}. This means that 'logcosh' works
mostly like the mean squared error, but will not be so strongly affected by
the occasional wildly incorrect prediction.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{y_true <- rbind(c(0., 1.), c(0., 0.))
y_pred <- rbind(c(1., 1.), c(0., 0.))
loss <- metric_log_cosh(y_true, y_pred)
loss
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor([0.2168904 0.       ], shape=(2), dtype=float32)

}\if{html}{\out{</div>}}
}

\seealso{
Other losses: \cr
\code{\link{Loss}()} \cr
\code{\link{loss_binary_crossentropy}()} \cr
\code{\link{loss_binary_focal_crossentropy}()} \cr
\code{\link{loss_categorical_crossentropy}()} \cr
\code{\link{loss_categorical_focal_crossentropy}()} \cr
\code{\link{loss_categorical_generalized_cross_entropy}()} \cr
\code{\link{loss_categorical_hinge}()} \cr
\code{\link{loss_circle}()} \cr
\code{\link{loss_cosine_similarity}()} \cr
\code{\link{loss_ctc}()} \cr
\code{\link{loss_dice}()} \cr
\code{\link{loss_hinge}()} \cr
\code{\link{loss_huber}()} \cr
\code{\link{loss_kl_divergence}()} \cr
\code{\link{loss_log_cosh}()} \cr
\code{\link{loss_mean_absolute_error}()} \cr
\code{\link{loss_mean_absolute_percentage_error}()} \cr
\code{\link{loss_mean_squared_error}()} \cr
\code{\link{loss_mean_squared_logarithmic_error}()} \cr
\code{\link{loss_poisson}()} \cr
\code{\link{loss_sparse_categorical_crossentropy}()} \cr
\code{\link{loss_squared_hinge}()} \cr
\code{\link{loss_tversky}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_categorical_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_squared_hinge}()} \cr

Other metrics: \cr
\code{\link{Metric}()} \cr
\code{\link{custom_metric}()} \cr
\code{\link{metric_auc}()} \cr
\code{\link{metric_binary_accuracy}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_binary_iou}()} \cr
\code{\link{metric_categorical_accuracy}()} \cr
\code{\link{metric_categorical_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_concordance_correlation}()} \cr
\code{\link{metric_cosine_similarity}()} \cr
\code{\link{metric_f1_score}()} \cr
\code{\link{metric_false_negatives}()} \cr
\code{\link{metric_false_positives}()} \cr
\code{\link{metric_fbeta_score}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_iou}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh_error}()} \cr
\code{\link{metric_mean}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_iou}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_mean_wrapper}()} \cr
\code{\link{metric_one_hot_iou}()} \cr
\code{\link{metric_one_hot_mean_iou}()} \cr
\code{\link{metric_pearson_correlation}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_precision}()} \cr
\code{\link{metric_precision_at_recall}()} \cr
\code{\link{metric_r2_score}()} \cr
\code{\link{metric_recall}()} \cr
\code{\link{metric_recall_at_precision}()} \cr
\code{\link{metric_root_mean_squared_error}()} \cr
\code{\link{metric_sensitivity_at_specificity}()} \cr
\code{\link{metric_sparse_categorical_accuracy}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_sparse_top_k_categorical_accuracy}()} \cr
\code{\link{metric_specificity_at_sensitivity}()} \cr
\code{\link{metric_squared_hinge}()} \cr
\code{\link{metric_sum}()} \cr
\code{\link{metric_top_k_categorical_accuracy}()} \cr
\code{\link{metric_true_negatives}()} \cr
\code{\link{metric_true_positives}()} \cr
}
\concept{losses}
\concept{metrics}
