% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advanced_patterns.R
\name{check_cartesian}
\alias{check_cartesian}
\title{Detect Potential Cartesian Product}
\usage{
check_cartesian(x, y, by, threshold = 10)
}
\arguments{
\item{x}{A data frame (left table).}

\item{y}{A data frame (right table).}

\item{by}{Column names to join by.}

\item{threshold}{Warn if result will exceed this many times the larger input.
Default 10.}
}
\value{
A list with explosion analysis.
}
\description{
Warns if a join will produce a very large result due to many-to-many
relationships (Cartesian product explosion).
}
\examples{
# Dangerous: both tables have duplicates
x <- data.frame(id = c(1, 1, 2, 2), val_x = 1:4)
y <- data.frame(id = c(1, 1, 2, 2), val_y = 1:4)

check_cartesian(x, y, by = "id")

}
\seealso{
\code{\link[=join_spy]{join_spy()}}, \code{\link[=join_strict]{join_strict()}}
}
