% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gam_cox.R
\name{edf_diagnostics}
\alias{edf_diagnostics}
\title{Effective Degrees of Freedom Diagnostics}
\usage{
edf_diagnostics(object)
}
\arguments{
\item{object}{A \code{"jmSurface"} object.}
}
\value{
Data frame with columns:
\item{transition}{Transition name}
\item{edf}{Effective degrees of freedom of the surface smooth}
\item{deviance_explained}{Proportion of deviance explained}
\item{n_obs}{Number of observations}
\item{n_events}{Number of events}
\item{complexity}{Character label: "Linear", "Moderate", or "Nonlinear"}
\item{p_value}{Approximate p-value for the smooth term}
}
\description{
Extracts EDF, deviance explained, and complexity diagnostics for each
transition-specific association surface. EDF near 1 indicates linearity;
EDF > 3 indicates substantial nonlinearity/interaction.
}
\details{
The EDF is computed as
\deqn{\mathrm{EDF}_{rs} = \mathrm{tr}\{(B'B + \lambda_{rs} S_{rs})^{-1} B'B\}}
and represents the realized complexity of the association surface after
REML-based penalization. Interpretation:
\itemize{
\item \code{EDF ~ 1}: Surface effectively linear; standard parametric JM suffices
\item \code{1 < EDF <= 3}: Moderate nonlinearity
\item \code{EDF > 3}: Substantial nonlinearity and/or interaction effects
}
}
