% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_statistic.R
\name{find_statistic}
\alias{find_statistic}
\title{Find statistic for model}
\usage{
find_statistic(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Currently not used.}
}
\value{
A character describing the type of statistic. If there is no
statistic available with a distribution, \code{NULL} will be returned.
}
\description{
Returns the statistic for a regression model (\emph{t}-statistic,
\emph{z}-statistic, etc.).

Small helper that checks if a model is a regression model
object and return the statistic used.
}
\examples{
# regression model object
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
find_statistic(m)
}
