% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inshiny-package.R
\name{use_inshiny}
\alias{use_inshiny}
\title{Manually include inshiny scripts and stylesheet}
\usage{
use_inshiny()
}
\value{
An \code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}} object to include in your UI.
}
\description{
For inshiny to work, you need to link your Shiny app to inshiny's JavaScript
code and CSS stylesheets. If you use inshiny's function \code{\link[=inline]{inline()}} anywhere
in your Shiny UI definition, which you probably do, this happens
automatically. Otherwise, you can add a call to \code{\link[=use_inshiny]{use_inshiny()}} to your UI.
}
\examples{
ui <- bslib::page(
    use_inshiny(),
    shiny::h1("My slider app"),
    inline_slider("slider", 50, 0, 100)
)
}
