% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findPattern.R
\name{findPattern}
\alias{findPattern}
\title{Find specific IBD patterns}
\usage{
findPattern(sims, pattern, merge = TRUE, cutoff = 0, unit = "mb")
}
\arguments{
\item{sims}{A \code{genomeSim} object, or a list of such. Typically made by
\code{\link[=ibdsim]{ibdsim()}}.}

\item{pattern}{A named list of vectors containing ID labels. Allowed names
are \code{autozygous}, \code{heterozygous}, \code{carriers}, \code{noncarriers}.}

\item{merge}{A logical, indicating if adjacent segments should be merged.
Default: TRUE.}

\item{cutoff}{A non-negative number. Segments shorter than this are excluded
from the output. Default: 0.}

\item{unit}{The unit of \code{cutoff}: either "mb" or "cm".}
}
\value{
A matrix (if \code{sims} is a single \code{genomeSim} object), or a list of
matrices.
}
\description{
Find segments satisfying a particular pattern of IBD sharing, in a list of
IBD simulations.
}
\details{
For each simulation, this function extracts the subset of rows satisfying the
allele sharing specified by \code{pattern}. That is, segments where, for some allele,
\itemize{
\item all of \code{pattern$autozygous} are autozygous
\item all of \code{pattern$heterozygous} have exactly one copy
\item all of \code{pattern$carriers} have at least one copy
\item none of \code{pattern$noncarriers} carry the allele.
}
}
\examples{
x = nuclearPed(3)
s = ibdsim(x, N = 1, map = uniformMap(M = 1), seed = 1729)

# Segments where some allele is shared by 3 and 4, but not 5
pattern = list(carriers = 3:4, noncarriers = 5)
findPattern(s, pattern)

# Exclude segments less than 7 cM
findPattern(s, pattern, cutoff = 7)

# Visual confirmation:
haploDraw(x, s)

}
\seealso{
\code{\link[=segmentStats]{segmentStats()}}
}
