% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{stations}
\alias{stations}
\title{List stations for a provider}
\usage{
stations(x, ...)
}
\arguments{
\item{x}{A \code{hydro_service} object created by \code{\link[=hydro_service]{hydro_service()}}.}

\item{...}{Passed to provider-specific methods.}
}
\value{
A tibble with station metadata.
}
\description{
List stations for a provider
}
\examples{
# Offline: enumerate providers (no network)
s <- hydro_services()
head(names(s))

\dontshow{if (interactive() && requireNamespace("curl", quietly = TRUE) && curl::has_internet() && identical(Sys.getenv("HYDRO_EXAMPLES"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Online (opt-in): fetch stations
x <- hydro_service("SE_SMHI")
st <- stations(x)
head(st)
\dontshow{\}) # examplesIf}
}
