% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventMaxima.R
\name{eventMaxima}
\alias{eventMaxima}
\title{Event identification (using local maxima as a basis)}
\usage{
eventMaxima(
  data,
  delta.y = 200,
  delta.x = 1,
  threshold = -1,
  out.style = "summary"
)
}
\arguments{
\item{data}{The data vector}

\item{delta.y}{Minimum allowable difference from a peak to a trough}

\item{delta.x}{Minimum spacing between peaks}

\item{threshold}{Value above which an event is considered to have occurred}

\item{out.style}{The type of output (currently either "summary" or "none")}
}
\value{
By default, the \code{out.style} returns the indices of the maximum in each event, as well as the value of
the maximum and the sum of the \code{data} in each event, alongside the start and end of the events. Otherwise just
the indices of start and end of events as a two column dataframe are returned.
}
\description{
Events are identified on the basis of local maxima with an "event" considered to have
occurred if the maxima is above a tolerable threshold of the neighbouring troughs/valleys.
}
\details{
If \code{delta.y} is negative it is applied a fractional decrease from the peak, otherwise it is
treated as an absolute value. The \code{threshold} is applied after the event separation meaning that if a trough
goes below the threshold but was originally considered one event it will continue to be considered one event.
This makes this method distinct from the peaks over threshold algorithm in \code{eventPOT}. The \code{threshold}
here should be thought of as a filter to remove trace amounts that are not part of an event rather than event separation
metric.
}
\examples{
# Example extracting events from quickflow
bf = baseflowB(dataBassRiver, alpha = 0.925)
qf = dataBassRiver - bf$bf
events = eventMaxima(qf, delta.y = 200, delta.x = 1, threshold = 0)
print(events)
plotEvents(qf, dates = NULL, events = events, type = "lineover", main = "")
# Other examples to try
# delta.y = 200; delta.x = 1 # 5 events identified
# delta.y = 500; delta.x = 1 # 3 events identified
# delta.y = 10;  delta.x = 7 # 2 events identified
}
\references{
  Wasko, C. & Guo, D. (2022) Understanding event runoff coefficient variability across Australia using the hydroEvents R package. Hydrological Processes <doi:10.1002/hyp.14563>.
}
\seealso{
\code{\link{calcStats}} \code{\link{eventBaseflow}} \code{\link{eventMaxima}} \code{\link{eventPOT}}
}
\keyword{baseflow}
\keyword{events}
