% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethCl_CS_Arbitrary.R
\name{flow_velocity}
\alias{flow_velocity}
\alias{flow_velocity,CSarbitrary-method}
\alias{flow_velocity,CScircle-method}
\title{Flow Velocity}
\usage{
flow_velocity(object, h, J, method = "Strickler",nu = 1.14e-6,...)
}
\arguments{
\item{object}{A CSarbitrary or CScircle object.}

\item{h}{Flow depth [m].}

\item{J}{Bottom slope  [-].}

\item{method}{Method to calculate the roughness. Allowed are "Strickler"
(equal roughness) "Einstein" (mean roughness) and "Prandtl-Coolebrook-White".}

\item{nu}{Kinematic viscosity [m2/s]. Only for CScircle objects}

\item{...}{Additional arguments.}
}
\value{
Flow velocity [m/s]
}
\description{
Calculates the flow velocity of a CSarbitrary or CScircle object for a
 given water level and bottom slope under uniform flow conditions.
}
\examples{

# Example for CSarbitrary object
x <- c(0, 4, 9, 13)
z <- c(2, 0, 0, 2)
cs <- CSarbitrary(x = x, z = z, xb_l = 4, xb_r = 9, kSt_B = 35,
                  kSt_l = 45, kSt_r = 45)
flow_velocity(cs, h = 1,J = 0.01, method = "Einstein")

# Example for CScircle object
csC <- CScircle(Di = 0.7,ks = 1.5, kSt = 75)
flow_velocity(csC, h = 0.46, J = 0.004)
flow_velocity(csC, h = 0.46, J = 0.004, method = "Prandtl-Coolebrook-White")

}
