% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{export_emulator_to_json}
\alias{export_emulator_to_json}
\title{Export Emulators}
\usage{
export_emulator_to_json(
  ems,
  inputs = NULL,
  filename = NULL,
  output.type = "json"
)
}
\arguments{
\item{ems}{The (list of) emulators to convert}

\item{inputs}{Any previous information from compressed emulators (mostly internal)}

\item{filename}{If provided, the location to save the JSON file created}

\item{output.type}{If filename = NULL, whether to return the JSON ("json") or object.}
}
\value{
Either the created object, or NULL if a filename is specified.
}
\description{
Exports emulators to non-R format
}
\details{
While having emulators saved in a native-R format (for example, as part of
an RData file) can be useful for fast loading, it might be prohibitive where
space is a consideration, or where emulators might be imported into other
languages. This function summarises the key features of deterministic
emulators, either returning the compressed details as an object or returning
a JSON file. If a filename is provided, then the JSON is automatically
saved to the relevant location.
}
\examples{
# Using the SIREmulators
ems <- SIREmulators$ems
single_em_json <- export_emulator_to_json(ems[[1]], output.type = "json")
single_em_json
all_em_json <- export_emulator_to_json(ems, output.type = "json")
# Checking with the corresponding import function
reconstruct_em <- import_emulator_from_json(single_em_json)
ems[[1]]
reconstruct_em

}
\seealso{
import_emulator_from_json
}
