% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHandling.R
\name{rmOutliersTrades}
\alias{rmOutliersTrades}
\title{Remove outliers in trades without using quote data}
\usage{
rmOutliersTrades(pData, maxi = 10, window = 50, type = "advanced", tz = NULL)
}
\arguments{
\item{pData}{a \code{data.table} or \code{xts} object at least containing the column \code{"PRICE"}.}

\item{maxi}{an integer, indicating the maximum number of median absolute deviations allowed.}

\item{window}{an integer, indicating the time window for which the "outlyingness" is considered.}

\item{type}{should be \code{"standard"} or \code{"advanced"} (see details).}

\item{tz}{fallback time zone used in case we we are unable to identify the timezone of the data, by default: \code{tz = NULL}. 
With the non-disk functionality, we attempt to extract the timezone from the \code{DT} column (or index) of the data, which may fail. 
In case of failure we use \code{tz} if specified, and if it is not specified, we use \code{"UTC"}.}
}
\value{
\code{xts} object or \code{data.table} depending on type of input.
}
\description{
Delete entries for which the price is outlying with respect to surrounding entries. 
In comparison to \link{tradesCleanupUsingQuotes}, this function doesn't need quote data.
}
\details{
\itemize{
\item If \code{type = "standard"}: Function deletes entries for which the price deviated by more than "maxi"
median absolute deviations from a rolling centered median (excluding
the observation under consideration) of window observations.
\item If \code{type = "advanced"}:  Function deletes entries for which the price deviates by more than "maxi"
median absolute deviations from the value closest to the price of
these three options:
\enumerate{
 \item Rolling centered median (excluding the observation under consideration)
 \item Rolling median of the following window of observations
 \item Rolling median of the previous window of observations
}
The advantage of this procedure compared to the "standard" proposed
by Barndorff-Nielsen et al. (2010, footnote 8) is that it will not incorrectly remove
large price jumps. Therefore this procedure has been set as the default
for removing outliers. 

Note that the median absolute deviation is taken over the entire
day. In case it is zero (which can happen if prices don't change much), 
the median absolute deviation is taken over a subsample without constant prices.
}
}
\references{
Barndorff-Nielsen, O. E., P. R. Hansen, A. Lunde, and N. Shephard (2009). Realized kernels in practice: Trades and quotes. \emph{Econometrics Journal}, 12, C1-C32.
}
\author{
Jonathan Cornelissen, Kris Boudt, and Onno Kleen.
}
\keyword{cleaning}
