% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_conversions.R
\name{hexify_lonlat_to_h_index}
\alias{hexify_lonlat_to_h_index}
\title{Convert longitude/latitude to hexagonal cell hierarchical index}
\usage{
hexify_lonlat_to_h_index(grid, lon, lat)
}
\arguments{
\item{grid}{Grid specification from hexify_grid()}

\item{lon}{Longitude vector in degrees (numeric, -180 to 180)}

\item{lat}{Latitude vector in degrees (numeric, -90 to 90)}
}
\value{
Data frame with columns:
\item{h_index}{Hierarchical index (character string)}
\item{face}{Icosahedron face number (integer, 0-19)}
}
\description{
Converts geographic coordinates (longitude, latitude) to hexagonal cell
hierarchical index strings. These strings encode the face, resolution, and
cell location in a Z-order (Morton code) format.
}
\details{
Most users should use \code{\link{hexify_lonlat_to_cell}} or
\code{\link{hexify_grid_to_cell}} which return DGGRID-compatible
integer cell IDs.

This function returns hierarchical index strings useful for:
\itemize{
\item Understanding the cell's position in the hierarchy
\item Prefix-based spatial queries
\item Parent/child cell relationships
}
}
\keyword{internal}
