% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_conversions.R
\name{hexify_roundtrip_test}
\alias{hexify_roundtrip_test}
\title{Round-trip accuracy test}
\usage{
hexify_roundtrip_test(grid, lon, lat, units = "km")
}
\arguments{
\item{grid}{Grid specification}

\item{lon}{Longitude to test}

\item{lat}{Latitude to test}

\item{units}{Distance units ("km" or "degrees")}
}
\value{
List with:
\item{original}{Original coordinates}
\item{cell}{Cell index}
\item{reconstructed}{Reconstructed coordinates}
\item{error}{Distance between original and reconstructed}
}
\description{
Tests the accuracy of the coordinate conversion functions by converting
coordinates to cells and back, measuring the distance between original
and reconstructed coordinates.
}
\seealso{
Other coordinate conversion: 
\code{\link{hexify_cell_id_to_quad_ij}()},
\code{\link{hexify_cell_to_icosa_tri}()},
\code{\link{hexify_cell_to_lonlat}()},
\code{\link{hexify_cell_to_plane}()},
\code{\link{hexify_cell_to_quad_ij}()},
\code{\link{hexify_cell_to_quad_xy}()},
\code{\link{hexify_grid_cell_to_lonlat}()},
\code{\link{hexify_grid_to_cell}()},
\code{\link{hexify_icosa_tri_to_plane}()},
\code{\link{hexify_icosa_tri_to_quad_ij}()},
\code{\link{hexify_icosa_tri_to_quad_xy}()},
\code{\link{hexify_lonlat_to_cell}()},
\code{\link{hexify_lonlat_to_plane}()},
\code{\link{hexify_lonlat_to_quad_ij}()},
\code{\link{hexify_quad_ij_to_cell}()},
\code{\link{hexify_quad_ij_to_icosa_tri}()},
\code{\link{hexify_quad_ij_to_xy}()},
\code{\link{hexify_quad_xy_to_cell}()},
\code{\link{hexify_quad_xy_to_icosa_tri}()}
}
\concept{coordinate conversion}
