% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment-ts-growth.R
\name{ts_growth_rate_augment}
\alias{ts_growth_rate_augment}
\title{Augment Data with Time Series Growth Rates}
\usage{
ts_growth_rate_augment(.data, .value, .names = "auto")
}
\arguments{
\item{.data}{A data frame or tibble containing the data to be augmented.}

\item{.value}{A quosure specifying the column(s) for which you want to
calculate growth rates.}

\item{.names}{Optional. A character vector specifying the names of the new
columns to be created. Use "auto" for automatic naming.}
}
\value{
A tibble that includes the original data and additional columns representing
the growth rates of the selected columns. The column names are either
automatically generated or as specified in the \code{.names} parameter.
}
\description{
This function is used to augment a data frame or tibble with time series
growth rates of selected columns. You can provide a data frame or tibble as
the first argument, the column(s) for which you want to calculate the growth
rates using the \code{.value} parameter, and optionally specify custom names for
the new columns using the \code{.names} parameter.
}
\examples{
data <- data.frame(
  Year = 1:5,
  Income = c(100, 120, 150, 180, 200),
  Expenses = c(50, 60, 75, 90, 100)
)
ts_growth_rate_augment(data, .value = c(Income, Expenses))

}
\seealso{
Other Augment Function: 
\code{\link{ts_acceleration_augment}()},
\code{\link{ts_velocity_augment}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Augment Function}
