#' Add meta-information to the data frame containing the input data

# DESCRIPTION ##################################################################
#' @description
#' This function adds meta-information of the input data within the data frame containing the input data.

# ARGUMENTS ####################################################################
#' @param df \code{Data frame} containing the input data
#' @param info \code{String} or \code{Data frame} with one row or \code{Vector} of length 1 showing additional information or id for the pollutant.

# VALUE ########################################################################
#' @returns
#' This function returns a \code{data frame} with binding the input data with the info columns (info_ is added to the column names)

#' @author Alberto Castro & Axel Luyten

#' @keywords internal




add_info <- function(df, info){

  if(base::is.null(info)){
    output <-
      dplyr::mutate(df, info = NULL)

  } else if(base::is.vector(info)) {
    output <-
      dplyr::mutate(df, info = info)

  } else if(base::is.data.frame(info)){

    output <-
      stats::setNames(info, base::paste0("info_column_", 1: base::length(base::names(info))))

    output <- dplyr::bind_cols(df, output)

  }

  return(output)

}
