% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sisab.R
\name{sisab_variables}
\alias{sisab_variables}
\title{List SISAB Variables}
\usage{
sisab_variables(type = "aps", search = NULL)
}
\arguments{
\item{type}{Character. Report type to show variables for.
\code{"aps"} (default), \code{"sb"}, \code{"acs"}, or \code{"pns"}.}

\item{search}{Character. Optional search term to filter variables by
name or description. Case-insensitive and accent-insensitive.}
}
\value{
A tibble with columns: variable, description, type, section.
}
\description{
Returns a tibble with available variables in the SISAB coverage data,
including descriptions and value types.
}
\examples{
sisab_variables()
sisab_variables(type = "sb")
sisab_variables(search = "cobertura")
}
\seealso{
Other sisab: 
\code{\link{sisab_cache_status}()},
\code{\link{sisab_clear_cache}()},
\code{\link{sisab_data}()},
\code{\link{sisab_info}()},
\code{\link{sisab_years}()}
}
\concept{sisab}
