% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pof.R
\name{pof_dictionary}
\alias{pof_dictionary}
\title{Get POF variable dictionary}
\usage{
pof_dictionary(
  year = "2017-2018",
  register = NULL,
  cache_dir = NULL,
  refresh = FALSE
)
}
\arguments{
\item{year}{Character. POF edition (e.g., "2017-2018"). Default is "2017-2018".}

\item{register}{Character. Register name. If NULL, returns all registers.
Default is NULL.}

\item{cache_dir}{Character. Directory for caching downloaded files.
Default uses \code{tools::R_user_dir("healthbR", "cache")}.}

\item{refresh}{Logical. If TRUE, re-download even if file exists in cache.
Default is FALSE.}
}
\value{
A tibble with variable definitions including: variable, description,
position, length, decimals, register.
}
\description{
Downloads and returns the variable dictionary for POF microdata.
The dictionary is cached locally to avoid repeated downloads.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
pof_dictionary("2017-2018", "morador", cache_dir = tempdir())
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{pof_variables}}, \code{\link{pof_data}}

Other pof: 
\code{\link{pof_cache_status}()},
\code{\link{pof_clear_cache}()},
\code{\link{pof_data}()},
\code{\link{pof_info}()},
\code{\link{pof_registers}()},
\code{\link{pof_variables}()},
\code{\link{pof_years}()}
}
\concept{pof}
