% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censo.R
\name{censo_sidra_tables}
\alias{censo_sidra_tables}
\title{List Census SIDRA tables}
\usage{
censo_sidra_tables(theme = NULL, year = NULL)
}
\arguments{
\item{theme}{Character. Filter by theme. NULL returns all themes.
Available themes: \code{"population"}, \code{"race"}, \code{"estimates"},
\code{"literacy"}, \code{"housing"}, \code{"sanitation"},
\code{"disability"}, \code{"indigenous"}, \code{"quilombola"},
\code{"fertility"}, \code{"education"}, \code{"labor"},
\code{"income"}, \code{"age_sex"}, \code{"urbanization"}.}

\item{year}{Character or numeric. Filter tables that contain data for
this year. NULL returns tables for all years.}
}
\value{
A tibble with columns: table_code, table_name, theme, years,
territorial_levels.
}
\description{
Returns a catalog of available SIDRA tables for the Census, organized by
theme.
}
\examples{
# list all Census tables
censo_sidra_tables()

# filter by theme
censo_sidra_tables(theme = "population")

# tables with 2022 data
censo_sidra_tables(year = 2022)
}
