/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5TSmodule.h" 

#include "H5private.h"  
#include "H5Eprivate.h" 
#include "H5TSpkg.h"    

#ifdef H5_HAVE_THREADS

#ifndef H5_HAVE_STDATOMIC_H

void
H5TS_atomic_init_int(H5TS_atomic_int_t *obj, int desired)
{
    FUNC_ENTER_NOAPI_NAMECHECK_ONLY

    
    H5TS_mutex_init(&obj->mutex, H5TS_MUTEX_TYPE_PLAIN);

    
    obj->value = desired;

    FUNC_LEAVE_NOAPI_VOID_NAMECHECK_ONLY
} 

void
H5TS_atomic_destroy_int(H5TS_atomic_int_t *obj)
{
    FUNC_ENTER_NOAPI_NAMECHECK_ONLY

    
    H5TS_mutex_destroy(&obj->mutex);

    FUNC_LEAVE_NOAPI_VOID_NAMECHECK_ONLY
} 

void
H5TS_atomic_init_uint(H5TS_atomic_uint_t *obj, unsigned desired)
{
    FUNC_ENTER_NOAPI_NAMECHECK_ONLY

    
    H5TS_mutex_init(&obj->mutex, H5TS_MUTEX_TYPE_PLAIN);

    
    obj->value = desired;

    FUNC_LEAVE_NOAPI_VOID_NAMECHECK_ONLY
} 

void
H5TS_atomic_destroy_uint(H5TS_atomic_uint_t *obj)
{
    FUNC_ENTER_NOAPI_NAMECHECK_ONLY

    
    H5TS_mutex_destroy(&obj->mutex);

    FUNC_LEAVE_NOAPI_VOID_NAMECHECK_ONLY
} 

void
H5TS_atomic_init_voidp(H5TS_atomic_voidp_t *obj, void *desired)
{
    FUNC_ENTER_NOAPI_NAMECHECK_ONLY

    
    H5TS_mutex_init(&obj->mutex, H5TS_MUTEX_TYPE_PLAIN);

    
    obj->value = desired;

    FUNC_LEAVE_NOAPI_VOID_NAMECHECK_ONLY
} 

void
H5TS_atomic_destroy_voidp(H5TS_atomic_voidp_t *obj)
{
    FUNC_ENTER_NOAPI_NAMECHECK_ONLY

    
    H5TS_mutex_destroy(&obj->mutex);

    FUNC_LEAVE_NOAPI_VOID_NAMECHECK_ONLY
} 

#endif 

#endif 
