/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define H5VL_FRIEND 

#include "H5private.h"  
#include "H5Eprivate.h" 
#include "H5Iprivate.h" 
#include "H5Pprivate.h" 
#include "H5VLpkg.h"    

#include "H5VLpassthru_private.h" 

hid_t             H5VL_PASSTHRU_g      = H5I_INVALID_HID;
H5VL_connector_t *H5VL_PASSTHRU_conn_g = NULL;

herr_t
H5VL__passthru_register(void)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    if (NULL == H5VL_PASSTHRU_conn_g)
        if (NULL == (H5VL_PASSTHRU_conn_g =
                         H5VL__register_connector(&H5VL_pass_through_g, H5P_VOL_INITIALIZE_DEFAULT)))
            HGOTO_ERROR(H5E_VOL, H5E_CANTREGISTER, FAIL, "can't register passthru VOL connector");

    
    if (H5I_VOL != H5I_get_type(H5VL_PASSTHRU_g)) {
        if ((H5VL_PASSTHRU_g = H5I_register(H5I_VOL, H5VL_PASSTHRU_conn_g, false)) < 0)
            HGOTO_ERROR(H5E_VOL, H5E_CANTREGISTER, FAIL, "can't create ID for passthru VOL connector");

        
        H5VL_conn_inc_rc(H5VL_PASSTHRU_conn_g);
    }

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

herr_t
H5VL__passthru_unregister(void)
{
    FUNC_ENTER_PACKAGE_NOERR

    
    H5VL_PASSTHRU_g      = H5I_INVALID_HID;
    H5VL_PASSTHRU_conn_g = NULL;

    FUNC_LEAVE_NOAPI(SUCCEED)
} 
