/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5Cmodule.h" 
#define H5C_TESTING    
#define H5F_FRIEND     

#include "H5private.h"          
#include "H5Cpkg.h"             
#include "H5Eprivate.h"         
#include "H5Fpkg.h"             
#include "H5Iprivate.h"         
#include "H5VLprivate.h"        
#include "H5VLnative_private.h" 

typedef struct {
    bool status; 
} H5C_tag_iter_vct_ctx_t;

static int
H5C__verify_cork_tag_test_cb(H5C_cache_entry_t *entry, void *_ctx)
{
    H5C_tag_iter_vct_ctx_t *ctx = (H5C_tag_iter_vct_ctx_t *)_ctx; 
    bool                    is_corked;                            
    int                     ret_value = H5_ITER_CONT;             

    
    FUNC_ENTER_PACKAGE

    
    assert(entry);
    assert(ctx);

    
    is_corked = entry->tag_info ? entry->tag_info->corked : false;

    
    if (is_corked != ctx->status)
        HGOTO_ERROR(H5E_CACHE, H5E_BADVALUE, H5_ITER_ERROR, "bad cork status");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

herr_t
H5C__verify_cork_tag_test(hid_t fid, H5O_token_t tag_token, bool status)
{
    H5F_t                 *f;                   
    H5C_t                 *cache;               
    H5C_tag_iter_vct_ctx_t ctx;                 
    haddr_t                tag;                 
    herr_t                 ret_value = SUCCEED; 

    
    FUNC_ENTER_PACKAGE

    
    if (NULL == (f = (H5F_t *)H5VL_object_verify(fid, H5I_FILE)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not a file");

    
    tag = HADDR_UNDEF;
    if (H5VL_native_token_to_addr(f, H5I_FILE, tag_token, &tag) < 0)
        HGOTO_ERROR(H5E_CACHE, H5E_CANTGET, FAIL, "can't get address for token");

    
    cache = f->shared->cache;

    
    ctx.status = status;

    
    if (H5C__iter_tagged_entries(cache, tag, false, H5C__verify_cork_tag_test_cb, &ctx) < 0)
        HGOTO_ERROR(H5E_CACHE, H5E_BADITER, FAIL, "iteration of tagged entries failed");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 
