% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcWO_data_frame.R
\name{calcWO.data.frame}
\alias{calcWO.data.frame}
\title{Win odds calculation using a data frame}
\usage{
\method{calcWO}{data.frame}(x, AVAL, TRTP, ref, alpha = 0.05, WOnull = 1, ...)
}
\arguments{
\item{x}{a data frame containing subject-level data.}

\item{AVAL}{variable in the data with ordinal analysis values.}

\item{TRTP}{the treatment variable in the data.}

\item{ref}{the reference treatment group.}

\item{alpha}{significance level. The default is 0.05.}

\item{WOnull}{the null hypothesis. The default is 1.}

\item{...}{additional parameters.}
}
\value{
a data frame containing the win odds and its confidence interval. It contains the following columns:
\itemize{
\item WO calculated win odds.
\item LCL lower confidence limit.
\item UCL upper confidence limit.
\item SE standard error of the win odds.
\item WOnull win odds of the null hypothesis (specified in the \code{WOnull} argument).
\item alpha two-sided significance level for calculating the confidence interval (specified in the \code{alpha} argument).
\item Pvalue p-value associated with testing the null hypothesis.
\item WP calculated win probability.
\item LCL_WP lower confidence limit for \code{WP}.
\item UCL_WP upper confidence limit for \code{WP}.
\item SE_WP standard error of the win probability.
\item SD_WP standard deviation of the win probability, calculated as \code{SE_WP} multiplied by \code{sqrt(N)}.
\item N total number of patients in the analysis.
}
}
\description{
Win odds calculation using a data frame
}
\examples{
data(HCE4)
calcWO(x = HCE4, AVAL = "AVAL", TRTP = "TRTP", ref = "P")
}
\references{
Gasparyan SB et al. "Adjusted win ratio with stratification: calculation methods and interpretation." Statistical Methods in Medical Research 30.2 (2021): 580-611. \url{doi:10.1177/0962280220942558}
}
\seealso{
\code{\link[=calcWO]{calcWO()}}, \code{\link[=calcWO.hce]{calcWO.hce()}}, \code{\link[=calcWO.formula]{calcWO.formula()}}.
}
