\name{plot.gsearly}
\alias{plot.gsearly}
\title{Plot a gsearly model}
\usage{
\method{plot}{gsearly}(x, plottype=1, ...)
}
\description{Plots data from a gsearly model constructed using either
  \code{gsearlyModel} or \code{gsearlyUser}.}
\arguments{
 \item{x}{A gsearly model from function either \code{\link{gsearlyModel}} or
   \code{\link{gsearlyUser}}.}
 \item{plottype}{A value which is one of either 1 or \code{"recruit"},
   2 or \code{"inform"}, 3 or \code{"plotBoundary"} and 4 or
   \code{"plotPower"}.}
 \item{...}{Further graphical parameters for lines and points.}
}
\value{
 A plot of the selected type.
}
\examples{

 # For 90 percent power (pow), a call to gsearlyModel provides a feasible design
 fp <- c(0.0000,0.0010,0.0250)
 tn <- c(0.4800,0.7200,0.9750)
 rctdesign <- gsearlyModel(rmodel="dilin", trecruit=36, s=3, tfu=c(3,6,12),
                   tinterims=c(16,31), pow=0.8,
                   cmodel="exponential", sd=20, rho=0.75, theta=8, fp=fp, tn=tn)
 plot(rctdesign, "recruit")

}
