% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropout.R
\name{Findno4sUPairs}
\alias{Findno4sUPairs}
\title{Find equivalent no4sU samples for 4sU samples}
\usage{
Findno4sUPairs(data, paired.replicates = FALSE, discard.no4sU = TRUE)
}
\arguments{
\item{data}{a grandR object}

\item{paired.replicates}{pair replicates, i.e. only no4sU.A is found for 4sU.A}

\item{discard.no4sU}{do not report references for no4sU samples}
}
\value{
a named list containing, for each 4sU sample, a vector of equivalent no4sU samples
}
\description{
Identify all no4sU samples in the same condition, and return everything as a list to be used in
\link{Plot4sUDropout}, \link{Plot4sUDropoutRank}, \link{Plot4sUDropoutAll}, \link{Plot4sUDropoutRankAll}
}
\examples{
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c("Condition",Design$dur.4sU,Design$Replicate))
Findno4sUPairs(sars)

}
\seealso{
\link{Plot4sUDropout}, \link{Plot4sUDropoutRank}, \link{Plot4sUDropoutAll}, \link{Plot4sUDropoutRankAll}
}
\concept{dropout}
