% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli_integration.R
\name{goose_configure}
\alias{goose_configure}
\title{Configure Goose CLI Settings}
\usage{
goose_configure(
  provider = NULL,
  model = NULL,
  api_key = NULL,
  save_to_renviron = FALSE,
  check_cli_first = TRUE
)
}
\arguments{
\item{provider}{Character string specifying the AI provider (e.g., "openai", "anthropic")}

\item{model}{Character string specifying the model (e.g., "gpt-4", "claude-3")}

\item{api_key}{Character string with the API key (stored securely)}

\item{save_to_renviron}{Logical, whether to save to .Renviron file}

\item{check_cli_first}{Logical, check if CLI already works before configuring (default TRUE)}
}
\value{
Invisible TRUE if successful
}
\description{
Set up Goose CLI configuration. Note: If Goose CLI is already configured
(e.g., for Block employees), this function is not needed. The package will
use the existing CLI configuration automatically.
}
\examples{
\dontrun{
# For Block employees with configured CLI, just check:
goose_test_cli()

# For external users who need API keys:
goose_configure(provider = "openai", model = "gpt-4", api_key = "your-key")
}
}
