% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify_similarity.R
\name{reduce_genesets}
\alias{reduce_genesets}
\title{Reduce the set of significant genesets to a minimum}
\usage{
reduce_genesets(
  clusters,
  simscore_threshold = 0.9,
  universe_fraction = 0.25,
  signifgenes_fraction = 0.9
)
}
\arguments{
\item{clusters}{results from \code{cluster_genesets()}}

\item{simscore_threshold}{similarity score (0~1) that is required to consider one geneset to be a "parent term" of another.
Setting a lower value will yield fewer genesets / stronger summarization.
Typical settings for this parameter are 0.8~0.99 (0.9 is default)}

\item{universe_fraction}{discard genesets that cover more than X fraction of all genes in the universe (unique set of genes covered by all significant genesets).
Setting this to 0.25 will deprioritize genesets that cover 25\% of all genes (in significant genesets).
This prevents very generic GO terms like "protein-containing complex" to be included in results.
Typical settings for this parameter are 0.1~0.5  (0.25 is default)}

\item{signifgenes_fraction}{the minimum fraction of "foreground genes" ('genes_signif' column) found across all significant genesets that should be covered by the reduced geneset collection.
This parameter doesn't do anything if there are fewer than 5 "foreground genes" alltogether.
Typical settings for this parameter are 0.75~0.95 (0.9 is default)}
}
\value{
the genesets table from the \code{clusters} parameter, with results in column "signif_and_reduced"
}
\description{
Analyses are performed independently per 'source' of genesets. The result of this function is the geneset table with a newly appended column 'signif_and_reduced'
}
