% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco-get-postal-codes.R
\encoding{UTF-8}
\name{gisco_get_postal_codes}
\alias{gisco_get_postal_codes}
\alias{gisco_get_postalcodes}
\title{Postal codes dataset}
\source{
\url{https://gisco-services.ec.europa.eu/distribution/v2/}.

Copyright:
\url{https://ec.europa.eu/eurostat/web/gisco/geodata/administrative-units}.
}
\usage{
gisco_get_postal_codes(
  year = 2024,
  country = NULL,
  cache_dir = NULL,
  update_cache = FALSE,
  verbose = FALSE,
  ext = "gpkg"
)
}
\arguments{
\item{year}{character string or number. Release year of the file. One of
\Sexpr[stage=render,results=rd]{giscoR:::db_values("postal_codes",
"year",TRUE)}.}

\item{country}{character vector of country codes. It could be either a
vector of country names, a vector of ISO3 country codes or a vector of
Eurostat country codes. See also \code{\link[countrycode:countrycode]{countrycode::countrycode()}}.}

\item{cache_dir}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.}

\item{update_cache}{logical. Should the cached file be refreshed?. Default
is \code{FALSE}. When set to \code{TRUE} it would force a new download.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}

\item{ext}{character. Extension of the file (default \code{"gpkg"}). One of
\Sexpr[stage=render,results=rd]{giscoR:::db_values("postal_codes",
"ext",TRUE)}.}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
The postal code point dataset shows the location of postal codes, NUTS codes
and the Degree of Urbanisation classification across the EU, EFTA and
candidate countries from a variety of sources. Its primary purpose is to
create correspondence tables for the NUTS classification (EC) 1059/2003 as
part of the Tercet Regulation (EU) 2017/2391.
}
\section{Copyright}{
The dataset is released under the CC-BY-SA-4.0 licence and requires the
following attribution whenever used:

© European Union - GISCO, 2024, postal code point dataset, Licence CC-BY-SA 4.0.
}

\section{Note}{
Please check the download and usage provisions on \code{\link[=gisco_attributions]{gisco_attributions()}}.
}

\examples{
\dontshow{if (gisco_check_access()) withAutoprint(\{ # examplesIf}

# Heavy-weight download!
\dontrun{

pc_bel <- gisco_get_postal_codes(country = "BE")

if (!is.null(pc_bel)) {
  library(ggplot2)

  ggplot(pc_bel) +
    geom_sf(color = "gold") +
    theme_bw() +
    labs(
      title = "Postcodes of Belgium",
      subtitle = "2024",
      caption = paste("\u00a9 European Union - GISCO, 2024,",
        "postal code point dataset",
        "Licence CC-BY-SA 4.0",
        sep = "\n"
      )
    )
}
}
\dontshow{\}) # examplesIf}
}
\seealso{
See \code{\link[=gisco_bulk_download]{gisco_bulk_download()}} to perform a bulk download of datasets.

Other administrative units datasets:
\code{\link{gisco_get_communes}()},
\code{\link{gisco_get_countries}()}
}
\concept{admin}
