#' Points, jittered to reduce overplotting using the vipor package
#'
#' The quasirandom geom is a convenient means to offset points within categories 
#' to reduce overplotting. Uses the vipor package.
#'
#' @param mapping Set of aesthetic mappings created by \code{\link[ggplot2]{aes}} or
#'   \code{\link[ggplot2]{aes_}}. If specified and \code{inherit.aes = TRUE} (the
#'   default), is combined with the default mapping at the top level of the
#'   plot. You only need to supply \code{mapping} if there isn't a mapping
#'   defined for the plot.
#' @param data A data frame. If specified, overrides the default data frame
#'   defined at the top level of the plot.
#' @param stat The statistical transformation to use on the data for this
#'    layer, as a string.
#' @param ... other arguments passed to [ggplot2::layer] `params` argument.
#' @inheritParams position_quasirandom
#' @param show.legend logical. Should this layer be included in the legends?
#'   \code{NA}, the default, includes if any aesthetics are mapped.
#'   \code{FALSE} never includes, and \code{TRUE} always includes.
#' @param inherit.aes If \code{FALSE}, overrides the default aesthetics,
#'   rather than combining with them. This is most useful for helper functions
#'   that define both data and aesthetics and shouldn't inherit behaviour from
#'   the default plot specification, e.g. \code{\link[ggplot2]{borders}}.
#' @seealso
#'  [vipor::offsetSingleGroup()] how spacing is determined,
#'  [ggplot2::geom_point()] for regular, unjittered points,
#'  [ggplot2::geom_jitter()] for jittered points,
#'  [ggplot2::geom_boxplot()] for another way of looking at the conditional
#'     distribution of a variable
#' @examples
#'   # Generate fake data
#'   distro <- data.frame(
#'     'variable'=rep(c('runif','rnorm'),each=100),
#'     'value'=c(runif(100, min=-3, max=3), rnorm(100))
#'   )
#'   ggplot2::ggplot(distro, ggplot2::aes(variable, value)) + 
#'   geom_quasirandom(width=0.1)
#' @export
geom_quasirandom <- function(
  mapping = NULL,
  data = NULL,
  stat = 'identity',
  ...,
  method = 'quasirandom',
  width = NULL,
  varwidth = FALSE,
  bandwidth = .5,
  nbins = NULL,
  dodge.width = NULL,
  groupOnX = NULL,
  orientation = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
) {
  
  position <- position_quasirandom(
    method = method,
    width = width, 
    varwidth = varwidth, 
    bandwidth = bandwidth,
    nbins = nbins,
    dodge.width = dodge.width,
    orientation = orientation,
    na.rm = na.rm
  )
  
  ggplot2::layer(
    data = data,
    mapping = mapping,
    stat = stat,
    geom = GeomPoint,
    position = position,
    show.legend = show.legend,
    inherit.aes = inherit.aes,
    params = list(
      na.rm = na.rm,
      ...
    )
  )
}
