% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygonarea.R
\name{polygon_area_cumulative}
\alias{polygon_area_cumulative}
\title{Compute cumulative polygon area and perimeter}
\usage{
polygon_area_cumulative(x, polyline = FALSE)
}
\arguments{
\item{x}{A two-column matrix or data frame of coordinates (longitude, latitude)
in decimal degrees defining polygon vertices, or a list with longitude and
latitude components.}

\item{polyline}{Logical. If FALSE (default), compute area and perimeter of a
closed polygon. If TRUE, compute only the length of a polyline (area will
be meaningless).}
}
\value{
A data frame with columns:
\itemize{
\item \code{lon}: Longitude of vertex
\item \code{lat}: Latitude of vertex
\item \code{area}: Cumulative area in square meters up to this vertex
\item \code{perimeter}: Cumulative perimeter in meters up to this vertex
}
}
\description{
Compute the area and perimeter of a polygon at each vertex, showing how
the measurements accumulate as vertices are added.
}
\details{
This function is useful for understanding how polygon area accumulates
and for debugging polygon vertex order issues.
}
\examples{
# Watch area accumulate as vertices are added
pts <- cbind(
  lon = c(0, -74, -43, 28),
  lat = c(52, 41, -23, -26)
)
polygon_area_cumulative(pts)
}
