% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpf_exporters.R
\name{export_as_txt}
\alias{export_as_txt}
\title{Export a table-like object to plain (ASCII) text with page breaks}
\usage{
export_as_txt(
  x,
  file = NULL,
  page_type = NULL,
  landscape = FALSE,
  pg_width = page_dim(page_type)[if (landscape) 2 else 1],
  pg_height = page_dim(page_type)[if (landscape) 1 else 2],
  font_family = "Courier",
  font_size = 8,
  lineheight = 1L,
  margins = c(top = 0.5, bottom = 0.5, left = 0.75, right = 0.75),
  paginate = TRUE,
  cpp = NA_integer_,
  lpp = NA_integer_,
  ...,
  hsep = NULL,
  indent_size = 2,
  tf_wrap = paginate,
  max_width = NULL,
  colwidths = NULL,
  min_siblings = 2,
  nosplitin = character(),
  rep_cols = NULL,
  verbose = FALSE,
  page_break = "\\\\s\\\\n",
  page_num = default_page_number(),
  fontspec = font_spec(font_family, font_size, lineheight),
  col_gap = 3,
  round_type = obj_round_type(x)
)
}
\arguments{
\item{x}{(\code{ANY})\cr a table-like object to export. Must have an applicable \code{matrix_form} method.}

\item{file}{(\code{string} or \code{NULL})\cr if non-\code{NULL}, the path to write a text file to
containing \code{x} rendered as ASCII text.}

\item{page_type}{(\code{string})\cr name of a page type. See \code{\link{page_types}}. Ignored
when \code{pg_width} and \code{pg_height} are set directly.}

\item{landscape}{(\code{flag})\cr whether the dimensions of \code{page_type} should be
inverted for landscape orientation. Defaults to \code{FALSE}, ignored when \code{pg_width} and
\code{pg_height} are set directly.}

\item{pg_width}{(\code{numeric(1)})\cr page width in inches.}

\item{pg_height}{(\code{numeric(1)})\cr page height in inches.}

\item{font_family}{(\code{string})\cr name of a font family. An error will be thrown
if the family named is not monospaced. Defaults to \code{"Courier"}.}

\item{font_size}{(\code{numeric(1)})\cr font size. Defaults to \code{12}.}

\item{lineheight}{(\code{numeric(1)})\cr line height. Defaults to \code{1}.}

\item{margins}{(\code{numeric(4)})\cr named numeric vector containing \code{"bottom"}, \code{"left"},
\code{"top"}, and \code{"right"} margins in inches. Defaults to \code{.5} inches for both vertical
margins and \code{.75} for both horizontal margins.}

\item{paginate}{(\code{flag})\cr whether pagination should be performed. Defaults to \code{TRUE}
if page size is specified (including the default).}

\item{cpp}{(\code{numeric(1)} or \code{NULL})\cr width (in characters) per page. If \code{NA} (the default), this is calculated
automatically based on the specified page size). \code{NULL} indicates no horizontal pagination should occur.}

\item{lpp}{(\code{numeric(1)} or \code{NULL})\cr lines per page. If \code{NA} (the default), this is calculated automatically
based on the specified page size). \code{NULL} indicates no vertical pagination should occur.}

\item{...}{additional parameters passed to \code{\link[=paginate_to_mpfs]{paginate_to_mpfs()}}.}

\item{hsep}{(\code{string})\cr character to repeat to create header/body separator line. If
\code{NULL}, the object value will be used. If \code{" "}, an empty separator will be printed. See
\code{\link[=default_hsep]{default_hsep()}} for more information.}

\item{indent_size}{(\code{numeric(1)})\cr indent size, in characters. Ignored when \code{x} is already
a \code{MatrixPrintForm} object in favor of information there.}

\item{tf_wrap}{(\code{flag})\cr whether the text for title, subtitles, and footnotes should be wrapped.}

\item{max_width}{(\code{integer(1)}, \code{string} or \code{NULL})\cr width that title and footer (including
footnotes) materials should be word-wrapped to. If \code{NULL}, it is set to the current print width of the
session (\code{getOption("width")}). If set to \code{"auto"}, the width of the table (plus any table inset) is
used. Parameter is ignored if \code{tf_wrap = FALSE}.}

\item{colwidths}{(\code{numeric})\cr vector of column widths (in characters) for use in vertical pagination.}

\item{min_siblings}{(\code{numeric})\cr minimum sibling rows which must appear on either side of pagination row for a
mid-subtable split to be valid. Defaults to 2 for tables. It is automatically turned off (set to 0) for listings.}

\item{nosplitin}{(\code{character})\cr list of names of subtables where page breaks are not allowed, regardless of other
considerations. Defaults to none.}

\item{rep_cols}{(\code{numeric(1)})\cr number of \emph{columns} (not including row labels) to be repeated on every page.
Defaults to 0.}

\item{verbose}{(\code{flag})\cr whether additional informative messages about the search for
pagination breaks should be shown. Defaults to \code{FALSE}.}

\item{page_break}{(\code{string})\cr page break symbol (defaults to \code{"\\\\n\\\\s"}).}

\item{page_num}{(\code{string})\cr placeholder string for page numbers. See \link{default_page_number} for more
information. Defaults to \code{NULL}.}

\item{fontspec}{(\code{font_spec})\cr a font_spec object specifying the font information to use for
calculating string widths and heights, as returned by \code{\link[=font_spec]{font_spec()}}.}

\item{col_gap}{(\code{numeric(1)})\cr The number of spaces to be placed between columns
in the rendered table (and assumed for horizontal pagination).}

\item{round_type}{(\code{string})\cr .
\cr The type of rounding to perform. Allowed values: (\code{"iec"}, \code{"iec_mod"} or \code{"sas"})
\cr iec, the default, and iec_mod performs rounding compliant with IEC 60559
(see notes in \code{\link[=round_fmt]{round_fmt()}}), while
sas performs nearest-value rounding consistent with rounding within SAS.\cr
In addition, the rounding of a negative number that rounds to zero will be presented as 0
(with the appropriate number of trailing zeros) for both \code{sas} and \code{iec_mod},
while for \code{iec}, it will be presented as -0 (with the appropriate number of trailing zeros).}
}
\value{
If \code{file} is \code{NULL}, the full paginated and concatenated string value is returned,
otherwise the output is written to \code{file} and no value (invisible \code{NULL}) is returned.
}
\description{
This function converts \code{x} to a \code{MatrixPrintForm} object via \code{\link[=matrix_form]{matrix_form()}}, paginates it
via \code{\link[=paginate_to_mpfs]{paginate_to_mpfs()}}, converts each page to ASCII text via \code{\link[=toString]{toString()}}, and outputs
the strings, separated by \code{page_break}, to \code{file}.
}
\details{
If \code{x} has a \code{num_rep_cols} method, the value returned by it will be used for \code{rep_cols} by
default. Otherwise, 0 will be used.

If \code{x} has an applicable \code{do_forced_paginate} method, it will be invoked during the
pagination process.
}
\examples{
export_as_txt(basic_matrix_form(mtcars), pg_height = 5, pg_width = 4)

}
