% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbats.R
\name{tbats.components}
\alias{tbats.components}
\title{Extract components of a TBATS model}
\usage{
tbats.components(x)
}
\arguments{
\item{x}{A tbats object created by \code{\link[=tbats]{tbats()}}.}
}
\value{
A multiple time series (\code{mts}) object. The first series is the observed time series. The second series is the trend component of the fitted model. Series three onwards are the seasonal components of the fitted model with one time series for each of the seasonal components. All components are transformed using estimated Box-Cox parameter.
}
\description{
Extract the level, slope and seasonal components of a TBATS model. The extracted components are Box-Cox transformed using the estimated transformation parameter.
}
\examples{

\dontrun{
fit <- tbats(USAccDeaths, use.parallel = FALSE)
components <- tbats.components(fit)
plot(components)
}

}
\references{
De Livera, A.M., Hyndman, R.J., & Snyder, R. D. (2011),
Forecasting time series with complex seasonal patterns using exponential
smoothing, \emph{Journal of the American Statistical Association},
\bold{106}(496), 1513-1527.
}
\seealso{
\code{\link[=tbats]{tbats()}}.
}
\author{
Slava Razbash and Rob J Hyndman
}
\keyword{ts}
