% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean.R
\name{mean_model}
\alias{mean_model}
\title{Mean Forecast Model}
\usage{
mean_model(y, lambda = NULL, biasadj = FALSE)
}
\arguments{
\item{y}{a numeric vector or univariate time series of class \code{ts}}

\item{lambda}{Box-Cox transformation parameter. If \code{lambda = "auto"},
then a transformation is automatically selected using \code{BoxCox.lambda}.
The transformation is ignored if NULL. Otherwise,
data transformed before model is estimated.}

\item{biasadj}{Use adjusted back-transformed mean for Box-Cox
transformations. If transformed data is used to produce forecasts and fitted
values, a regular back transformation will result in median forecasts. If
biasadj is \code{TRUE}, an adjustment will be made to produce mean forecasts
and fitted values.}
}
\value{
An object of class \code{mean_model}.
}
\description{
Fits a Gaussian iid model to a univariate time series.
}
\details{
The model assumes that the data are independent and identically distributed

\deqn{Y_t \sim N(\mu,\sigma^2)}{Y[t] ~ N(mu, sigma^2)}

Forecasts are given by

\deqn{Y_{n+h|n}=\mu}{Y[n+h|n]=mu}

where \eqn{\mu}{mu} is estimated by the sample mean.

The function \code{\link[=summary]{summary()}} is used to obtain and print a summary of the
results, while the function \code{\link[=plot]{plot()}} produces a plot of the forecasts and
prediction intervals.
The generic accessor functions \code{\link[stats:fitted.values]{stats::fitted()}} and \code{\link[stats:residuals]{stats::residuals()}}
extract useful features of the object returned by \code{\link[=mean_model]{mean_model()}}.
}
\section{forecast class}{

An object of class \code{forecast} is a list usually containing at least
the following elements:
\describe{
\item{model}{A list containing information about the fitted model}
\item{method}{The name of the forecasting method as a character string}
\item{mean}{Point forecasts as a time series}
\item{lower}{Lower limits for prediction intervals}
\item{upper}{Upper limits for prediction intervals}
\item{level}{The confidence values associated with the prediction intervals}
\item{x}{The original time series.}
\item{residuals}{Residuals from the fitted model. For models with additive
errors, the residuals will be x minus the fitted values.}
\item{fitted}{Fitted values (one-step forecasts)}
}
The function \code{summary} can be used to obtain and print a summary of the
results, while the functions \code{plot} and \code{autoplot} produce plots of the forecasts and
prediction intervals. The generic accessors functions \code{fitted.values} and \code{residuals}
extract various useful features from the underlying model.
}

\examples{
fit_nile <- mean_model(Nile)
fit_nile |> forecast(h = 10) |> autoplot()
}
\seealso{
\code{\link[=forecast.mean_model]{forecast.mean_model()}}, \code{\link[=meanf]{meanf()}}
}
\author{
Rob J Hyndman
}
\keyword{ts}
