% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastBATS.R, R/forecastTBATS.R
\name{forecast.bats}
\alias{forecast.bats}
\alias{forecast.tbats}
\title{Forecasting using BATS and TBATS models}
\usage{
\method{forecast}{bats}(object, h, level = c(80, 95), fan = FALSE, biasadj = NULL, ...)

\method{forecast}{tbats}(
  object,
  h,
  level = c(80, 95),
  fan = FALSE,
  simulate = FALSE,
  bootstrap = FALSE,
  innov = NULL,
  npaths = 5000,
  biasadj = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \code{bats}. Usually the result of a call to
\code{\link[=bats]{bats()}}.}

\item{h}{Number of periods for forecasting. Default value is twice the
largest seasonal period (for seasonal data) or ten (for non-seasonal data).}

\item{level}{Confidence levels for prediction intervals.}

\item{fan}{If \code{TRUE}, \code{level} is set to \code{seq(51, 99, by = 3)}.
This is suitable for fan plots.}

\item{biasadj}{Use adjusted back-transformed mean for Box-Cox
transformations. If transformed data is used to produce forecasts and fitted
values, a regular back transformation will result in median forecasts. If
biasadj is \code{TRUE}, an adjustment will be made to produce mean forecasts
and fitted values.}

\item{...}{Other arguments are ignored.}

\item{simulate}{If \code{TRUE}, prediction intervals are produced by simulation rather
than using analytic formulae. Errors are assumed to be normally distributed.}

\item{bootstrap}{If \code{TRUE}, then prediction intervals are produced by
simulation using resampled errors (rather than normally distributed errors). Ignored if \code{innov} is not \code{NULL}.}

\item{innov}{Optional matrix of future innovations to be used in
simulations. Ignored if \code{simulate = FALSE}. If provided, this overrides the \code{bootstrap} argument. The matrix
should have \code{h} rows and \code{npaths} columns.}

\item{npaths}{Number of sample paths used in computing simulated prediction
intervals.}
}
\value{
An object of class \code{forecast}.
}
\description{
Forecasts \code{h} steps ahead with a BATS model. Prediction intervals are
also produced.
}
\section{forecast class}{

An object of class \code{forecast} is a list usually containing at least
the following elements:
\describe{
\item{model}{A list containing information about the fitted model}
\item{method}{The name of the forecasting method as a character string}
\item{mean}{Point forecasts as a time series}
\item{lower}{Lower limits for prediction intervals}
\item{upper}{Upper limits for prediction intervals}
\item{level}{The confidence values associated with the prediction intervals}
\item{x}{The original time series.}
\item{residuals}{Residuals from the fitted model. For models with additive
errors, the residuals will be x minus the fitted values.}
\item{fitted}{Fitted values (one-step forecasts)}
}
The function \code{summary} can be used to obtain and print a summary of the
results, while the functions \code{plot} and \code{autoplot} produce plots of the forecasts and
prediction intervals. The generic accessors functions \code{fitted.values} and \code{residuals}
extract various useful features from the underlying model.
}

\examples{

\dontrun{
fit <- bats(USAccDeaths)
plot(forecast(fit))

taylor.fit <- bats(taylor)
plot(forecast(taylor.fit))
}

}
\references{
De Livera, A.M., Hyndman, R.J., & Snyder, R. D. (2011),
Forecasting time series with complex seasonal patterns using exponential
smoothing, \emph{Journal of the American Statistical Association},
\bold{106}(496), 1513-1527.
}
\seealso{
\code{\link[=bats]{bats()}}, \code{\link[=tbats]{tbats()}}, \code{\link[=forecast.ets]{forecast.ets()}}.
}
\author{
Slava Razbash and Rob J Hyndman
}
\keyword{ts}
