% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/reg-methods.R
\name{shift}
\alias{shift}
\alias{shift.Reg}
\title{Shift a time series object}
\usage{
shift(x, ...)

\method{shift}{Reg}(x, shift_amount, ...)
}
\arguments{
\item{x}{An object representing a time series or a time-based data structure}

\item{...}{Additional arguments passed to methods}

\item{shift_amount}{Numeric; amount to shift by (positive = forward, negative = backward)}
}
\value{
An object of the same class as the input, with values shifted in time:
  \describe{
    \item{Values}{Values are moved by the specified offset}
    \item{Structure}{Object structure and dimensions are preserved}
    \item{Padding}{Empty regions are filled with padding value}
  }
}
\description{
Apply a temporal shift to a time series object. This function shifts the values in time 
while preserving the structure of the object. Common uses include:
\describe{
  \item{alignment}{Aligning regressors with different temporal offsets}
  \item{derivatives}{Applying temporal derivatives to time series}
  \item{correction}{Correcting for timing differences between signals}
}
}
\examples{
# Create a simple time series with events
event_data <- data.frame(
  onsets = c(1, 10, 20, 30),
  run = c(1, 1, 1, 1)
)

# Create regressor from events
reg <- regressor(
  onsets = event_data$onsets,
  hrf = HRF_SPMG1,
  duration = 0,
  amplitude = 1
)

# Shift regressor forward by 2 seconds
reg_forward <- shift(reg, shift_amount = 2)

# Shift regressor backward by 1 second
reg_backward <- shift(reg, shift_amount = -1)

# Evaluate original and shifted regressors
times <- seq(0, 50, by = 2)
orig_values <- evaluate(reg, times)
shifted_values <- evaluate(reg_forward, times)
}
\seealso{
[regressor()], [evaluate()]
}
\concept{time_series}
