% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf-functions.R
\name{hrf_spmg1}
\alias{hrf_spmg1}
\title{hrf_spmg1}
\usage{
hrf_spmg1(t, P1 = 5, P2 = 15, A1 = 0.0833)
}
\arguments{
\item{t}{A vector of time points.}

\item{P1}{The first exponent parameter (default: 5).}

\item{P2}{The second exponent parameter (default: 15).}

\item{A1}{Amplitude scaling factor for the positive gamma function component; normally fixed at .0833}
}
\value{
A vector of HRF values at the given time points.
}
\description{
A hemodynamic response function based on the SPM canonical double gamma parameterization.
}
\details{
This function models the hemodynamic response using the canonical double gamma parameterization
in the SPM software. The HRF is defined by a linear combination of two gamma functions with
different exponents (P1 and P2) and amplitudes (A1 and A2). It is commonly used in fMRI data
analysis to estimate the BOLD (blood-oxygen-level-dependent) signal changes associated with
neural activity.
}
\examples{
# Generate a time vector
time_points <- seq(0, 30, by=0.1)
# Compute the HRF values using the SPM canonical double gamma parameterization
hrf_values <- hrf_spmg1(time_points)
# Plot the HRF values
plot(time_points, hrf_values, type='l', main='SPM Canonical Double Gamma HRF')
}
\seealso{
Other hrf_functions: 
\code{\link{hrf_basis_lwu}()},
\code{\link{hrf_boxcar}()},
\code{\link{hrf_bspline}()},
\code{\link{hrf_gamma}()},
\code{\link{hrf_gaussian}()},
\code{\link{hrf_inv_logit}()},
\code{\link{hrf_lwu}()},
\code{\link{hrf_mexhat}()},
\code{\link{hrf_sine}()},
\code{\link{hrf_time}()},
\code{\link{hrf_weighted}()}
}
\concept{hrf_functions}
