% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fc_modify.R
\name{fc_modify}
\alias{fc_modify}
\title{fc_modify}
\usage{
fc_modify(object, fun, ...)
}
\arguments{
\item{object}{flowchart created as a fc object.}

\item{fun}{A function or formula that will be applied to \code{.$fc}. If a \emph{function}, it is used as is. If a \emph{formula}, e.g. \code{fun = ~.x |> mutate(x = x + 0.2)}, it is converted to a function.}

\item{...}{Additional arguments passed on to the mapped function.}
}
\value{
List with the dataset and the modified flowchart parameters.
}
\description{
This function allows to modify the \code{.$fc} tibble included in each fc object that contains all the parameters of the flowchart.
}
\examples{
#Example: let's modify the excluded box
text_exc <- paste0(
  sum(safo$inclusion_crit == "Yes"),
  " not met the inclusion criteria\n",
  sum(safo$exclusion_crit == "Yes"),
  " met the exclusion criteria"
)

safo |>
  as_fc(label = "Patients assessed for eligibility") |>
  fc_filter(!is.na(group), label = "Randomized", show_exc = TRUE) |>
  fc_modify(
    ~ . |>
      dplyr::mutate(
        text = ifelse(id == 3, text_exc, text),
        x = ifelse(id == 3, 0.75, x)
      )
  ) |>
  fc_draw()

}
