% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{plot_fitted}
\alias{plot_fitted}
\title{Plot Fitted Distribution with Diagnostic Plots}
\usage{
plot_fitted(
  data,
  pdf_fun,
  cdf_fun,
  par,
  q_fun = NULL,
  xlim = NULL,
  ylim_pdf = NULL,
  ylim_cdf = NULL,
  lwd = 3,
  lty = 2,
  col_pdf = "yellow",
  col_cdf = "red",
  col_qq = "purple",
  col_pp = "darkgreen"
)
}
\arguments{
\item{data}{Numeric vector of observed data.}

\item{pdf_fun}{Function to compute the PDF; must take (par, x).}

\item{cdf_fun}{Function to compute the CDF; must take (par, x).}

\item{par}{Numeric vector of fitted parameters.}

\item{q_fun}{Optional quantile function; must take (par, p). Default = NULL.}

\item{xlim}{Numeric vector of length 2 for x-axis limits (default = range of data).}

\item{ylim_pdf}{Numeric vector for y-axis limits of the PDF plot.}

\item{ylim_cdf}{Numeric vector for y-axis limits of the CDF plot.}

\item{lwd}{Line width for curves (default = 3).}

\item{lty}{Line type for curves (default = 2).}

\item{col_pdf}{Color for the PDF curve (default = "yellow").}

\item{col_cdf}{Color for the CDF curve (default = "red").}

\item{col_qq}{Color for QQ-plot points (default = "purple").}

\item{col_pp}{Color for PP-plot points (default = "darkgreen").}
}
\value{
NULL (plots are generated as a side effect)
}
\description{
This function produces a 2x2 panel of plots for a fitted distribution:
1. Fitted PDF over histogram of data
2. Fitted CDF vs empirical CDF
3. QQ-plot (Theoretical vs Sample Quantiles)
4. PP-plot (Fitted CDF vs Empirical CDF)
}
