% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convert_file}
\alias{convert_file}
\title{Convert a single register SAS file to Parquet}
\usage{
convert_file(path, output_dir, chunk_size = 10000000L)
}
\arguments{
\item{path}{Path to a single SAS file.}

\item{output_dir}{Directory to save the Parquet output to. Must not include
the register name as this will be extracted from \code{path} to create the
register folder.}

\item{chunk_size}{Number of rows to read and convert at a time.}
}
\value{
\code{output_dir}, invisibly.
}
\description{
To be able to handle larger-than-memory files, the SAS file is converted in
chunks. It does not check for existing files in the output directory.
Existing data will not be overwritten, but might be duplicated if it already
exists in the directory, since files are saved with UUIDs in their names.
}
\examples{
sas_file <- fs::path_package("fastreg", "extdata", "test.sas7bdat")
convert_file(
  path = sas_file,
  output_dir = fs::path_temp("path/to/output/file")
)
}
