% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/14_GRM.R
\name{grm_iif}
\alias{grm_iif}
\title{Item Information Function for GRM}
\usage{
grm_iif(theta, a, b)
}
\arguments{
\item{theta}{Latent trait value of the subject}

\item{a}{Discrimination parameter of IRF}

\item{b}{Vector of difficulty parameters (thresholds) of IRF}
}
\value{
Value of the Item Information Function
}
\description{
Calculates the value of the Item Information Function for the Graded Response Model.
}
\examples{
\dontrun{
# Example for an item with 3 categories
a <- 1.5
b <- c(-1.0, 1.0)
thetas <- seq(-3, 3, by = 0.1)
info <- sapply(thetas, function(t) grm_iif(t, a, b))
plot(thetas, info, type = "l", xlab = "Theta", ylab = "Information")
}
}
