% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04A_IRTbaseFunctions.R
\name{TestResponseFunc}
\alias{TestResponseFunc}
\title{TRF for IRT}
\usage{
TestResponseFunc(params, theta)
}
\arguments{
\item{params}{parameter matrix}

\item{theta}{ability parameter}
}
\value{
A numeric vector with the same length as theta, containing the expected total score
for each ability level.
}
\description{
Calculates the expected score across all items on a test for a given ability level (theta)
using Item Response Theory. The Test Response Function (TRF) is essentially the sum of
the Item Characteristic Curves (ICCs) for all items in the test.
}
\details{
The Test Response Function computes the expected total score for an examinee with a given
ability level (theta) across all items in the test. For each item, the function uses the
logistic model with parameters a (discrimination), b (difficulty), c (guessing), and
d (upper asymptote).
}
