% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{drop_outliers}
\alias{drop_outliers}
\title{Drop outliers}
\usage{
drop_outliers(sessions)
}
\arguments{
\item{sessions}{tibble, sessions data set in evprof standard format}
}
\value{
sessions without outliers nor column \code{Outlier}
}
\description{
Drop outliers
}
\examples{
library(dplyr)
sessions_outliers <- california_ev_sessions \%>\%
  sample_frac(0.05) \%>\%
  detect_outliers(start = 3, noise_th = 5, eps = 2.5)

plot_outliers(sessions_outliers, start = 3)

sessions_clean <- drop_outliers(sessions_outliers)

plot_points(sessions_clean, start = 3)


}
