% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_palette.R
\name{remove_palette}
\alias{remove_palette}
\title{Remove a Saved Palette JSON}
\usage{
remove_palette(name, type = NULL, color_dir, log = TRUE)
}
\arguments{
\item{name}{Character. Palette name (without '.json' suffix).}

\item{type}{Character. Optional. Preferred type ("sequential", "diverging", or "qualitative").}

\item{color_dir}{Character. Root folder where palettes are stored (required). Use tempdir() for examples/tests.}

\item{log}{Logical. Whether to log palette removal to a temporary log file.}
}
\value{
Invisibly TRUE if removed successfully, FALSE otherwise.
}
\description{
Remove a palette file by name, trying across types if necessary.
}
\examples{
\dontrun{
# Remove a palette (requires write permissions):
remove_palette("seq_blues")

# Remove with specific type:
remove_palette("qual_vivid", type = "qualitative")
}
}
