% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{cycle-ergmTerm}
\alias{cycle-ergmTerm}
\alias{InitErgmTerm.cycle}
\title{k-Cycle Census}
\usage{
# binary: cycle(k, semi=FALSE)
}
\arguments{
\item{k}{a vector of integers giving the cycle lengths to count.
Directed cycle lengths may range from \code{2} to \code{N} (the network size); undirected
cycle lengths and semicycle lengths may range from \code{3} to \code{N} ; length 2 semicycles
are not currently supported.}

\item{semi}{an optional logical indicating whether semicycles
(rather than directed cycles) should be counted; this is ignored in the
undirected case.}

\item{directed}{2-cycles are equivalent to mutual dyads.}
}
\description{
This term adds one network statistic to the model for each value of \code{k} ,
corresponding to the number of \code{k} -cycles (or, alternately, semicycles)
in the graph.

This term can be used with either directed or undirected networks.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "cycle", "subsection")}
}
\concept{directed}
\concept{undirected}
