% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_functions.R,
%   R/binary_method_functions.R, R/ordinal_method_functions.R
\name{random_start}
\alias{random_start}
\alias{random_start_binary}
\alias{random_start_ordinal}
\title{Generate a random initial starting point for EM algorithm}
\usage{
random_start(type, n_method, method_names)

random_start_binary(n_method = NULL, method_names = NULL)

random_start_ordinal(n_method = NULL, method_names = NULL)
}
\arguments{
\item{type}{A string specifying the data type of the methods being simulated.}

\item{n_method}{An integer representing the number of methods to simulate.}

\item{method_names}{Optional vector of names used to identify each method.}
}
\value{
List containing initial values to be passed to \code{init} argument
}
\description{
\code{random_start()} is a general function for creating a random, plausible starting point
for the EM algorithm to begin iterating from. Varying the starting points of repeated
calculations can help the researcher detect local extremes.

Creates random initial sensitivity and specificity values for \code{n_method} methods.
Values are generated from a random beta distribution with shape parameters
\code{a=3} and \code{b=1}. Prevalence is a random value from a uniform distribution.
}
