% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lead_processing.R
\name{raw_to_lead}
\alias{raw_to_lead}
\title{Process raw LEAD data into clean format}
\usage{
raw_to_lead(data, vintage)
}
\arguments{
\item{data}{A data frame of raw LEAD data from OpenEI}

\item{vintage}{Character string indicating the ACS vintage year ("2016", "2018", "2022", etc.)}
}
\value{
A data frame with standardized column names:
\item{geoid}{11-digit census tract GEOID as character}
\item{state_abbr}{2-letter state abbreviation (2018+ only)}
\item{housing_tenure}{Housing tenure category}
\item{year_constructed}{Year building was constructed category}
\item{building_type}{Building type category}
\item{min_units}{Minimum number of units in building}
\item{detached}{Whether building is detached (1/0)}
\item{primary_heating_fuel}{Primary heating fuel type}
\item{income_bracket}{Income bracket category (depends on dataset: AMI, FPL, etc.)}
\item{households}{Number of households}
\item{income}{Annual income}
\item{electricity_spend}{Annual electricity spending}
\item{gas_spend}{Annual gas spending}
\item{other_spend}{Annual other fuel spending}
}
\description{
Converts raw LEAD data downloaded from OpenEI into a standardized clean format
suitable for analysis. Handles both 2016 (SH) and 2018+ ACS vintages.
}
\keyword{internal}
