% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-ideb.R
\name{get_ideb_series}
\alias{get_ideb_series}
\title{Get IDEB historical series}
\usage{
get_ideb_series(
  years = NULL,
  level = c("escola", "municipio"),
  stage = c("anos_iniciais", "anos_finais", "ensino_medio"),
  uf = NULL,
  quiet = FALSE
)
}
\arguments{
\item{years}{Vector of years to include (default: all available).}

\item{level}{The aggregation level.}

\item{stage}{The education stage.}

\item{uf}{Optional. Filter by state.}

\item{quiet}{Logical. If \code{TRUE}, suppresses progress messages.}
}
\value{
A tibble with IDEB data for all requested years.
}
\description{
Downloads and combines IDEB data across multiple years to create
a historical series.
}
\examples{
\dontrun{
# get IDEB history for municipalities
ideb_hist <- get_ideb_series(
  years = c(2017, 2019, 2021),
  level = "municipio",
  stage = "anos_iniciais"
)
}
}
