% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-enem.R
\name{enem_summary}
\alias{enem_summary}
\title{Summary statistics for ENEM scores}
\usage{
enem_summary(data, by = NULL)
}
\arguments{
\item{data}{A tibble with ENEM data (from \code{\link[=get_enem]{get_enem()}}).}

\item{by}{Optional grouping variable(s) as character vector.}
}
\value{
A tibble with summary statistics for each score area.
}
\description{
Calculates summary statistics for ENEM scores, optionally grouped
by demographic variables.
}
\examples{
\dontrun{
enem <- get_enem(2023, n_max = 10000)

# overall summary
enem_summary(enem)

# summary by sex
enem_summary(enem, by = "tp_sexo")
}
}
