% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start_activities.R
\name{start_activities}
\alias{start_activities}
\alias{start_activities.eventlog}
\alias{start_activities.grouped_eventlog}
\alias{start_activities.activitylog}
\alias{start_activities.grouped_activitylog}
\title{Start Activities}
\usage{
start_activities(
  log,
  level = c("log", "case", "activity", "resource", "resource-activity"),
  sort = TRUE
)

\method{start_activities}{eventlog}(
  log,
  level = c("log", "case", "activity", "resource", "resource-activity"),
  sort = TRUE
)

\method{start_activities}{grouped_eventlog}(
  log,
  level = c("log", "case", "activity", "resource", "resource-activity"),
  sort = TRUE
)

\method{start_activities}{activitylog}(
  log,
  level = c("log", "case", "activity", "resource", "resource-activity"),
  sort = TRUE
)

\method{start_activities}{grouped_activitylog}(
  log,
  level = c("log", "case", "activity", "resource", "resource-activity"),
  sort = TRUE
)
}
\arguments{
\item{log}{\code{\link[bupaR]{log}}: Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}}, \code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.).}

\item{level}{\code{\link{character}} (default \code{"log"}): Level of granularity for the analysis: \code{"log"} (default),
\code{"case"}, \code{"activity"}, \code{"resource"}, or \code{"resource-activity"}. For more information,
see \code{vignette("metrics", "edeaR")} and 'Details' below.}

\item{sort}{\code{\link{logical}} (default \code{TRUE}): Sort output on count. Only for levels with frequency count output.}
}
\description{
Analyse the start activities in the process.
}
\details{
Argument \code{level} has the following options:
\itemize{
\item On \code{"log"} level, this metric shows the absolute and relative number of activities that are the first activity
in one or more of the cases.
\item On \code{"case"} level, this metric provides an overview of the start activity of each case.
\item On \code{"activity"} level, this metric calculates for each activity the absolute and relative number of cases
that start with this activity type. Similar to the \code{\link{end_activities}} metric, the relative number is calculated
as a portion of the number of cases, being the number of "opportunities" that an activity could be the start activity.
The cumulative sum is added to have an insight in the number of activities that is required to cover a certain part of the total.
\item On \code{"resource"} level, an overview of which resources execute the first activity per case are provided.
\item On \code{"resource-activity"} level, this metric shows for each occurring resource-activity combination the absolute
and relative number of times this resource executes this activity as an start activity in a case.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{start_activities(eventlog)}: Computes the start activities for an \code{\link[bupaR]{eventlog}}.

\item \code{start_activities(grouped_eventlog)}: Computes the start activities for a \code{\link[bupaR]{grouped_eventlog}}.

\item \code{start_activities(activitylog)}: Computes the start activities for an \code{\link[bupaR]{activitylog}}.

\item \code{start_activities(grouped_activitylog)}: Computes the start activities for a \code{\link[bupaR]{grouped_activitylog}}.

}}
\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
\seealso{
\code{\link{end_activities}}

Other metrics: 
\code{\link{activity_frequency}()},
\code{\link{activity_presence}()},
\code{\link{end_activities}()},
\code{\link{idle_time}()},
\code{\link{number_of_repetitions}()},
\code{\link{number_of_selfloops}()},
\code{\link{number_of_traces}()},
\code{\link{processing_time}()},
\code{\link{resource_frequency}()},
\code{\link{resource_involvement}()},
\code{\link{resource_specialisation}()},
\code{\link{throughput_time}()},
\code{\link{trace_coverage}()},
\code{\link{trace_length}()}
}
\concept{metrics}
\concept{metrics_structuredness}
